package org.mule.weave.v2.compilation.mapper.nonAst

import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.UnknownLocation
import org.mule.weave.v2.compilation.mapper.DWSerializer
import org.mule.weave.v2.compilation.mapper.ast.NameIdentifierSerializer
import org.mule.weave.v2.interpreted.marker.InvalidReferenceValue
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object InvalidReferenceValueSerializer extends DWSerializer[InvalidReferenceValue] {

  override def serialize(invalidReference: InvalidReferenceValue): SerializableAstNode = {
    val children = Seq(
      NameIdentifierSerializer.serialize(invalidReference.reference),
      NoSourceLocationValueSerializer.serialize(invalidReference.location))
    NodeSerializableAstNode(SerializableAstNodeKind.INVALID_REFERENCE_VALUE_NODE, UnknownLocation, children)
  }

  override def deserialize(node: SerializableAstNode, resource: WeaveResource, identifier: NameIdentifier): InvalidReferenceValue = {
    val reference = NameIdentifierSerializer.deserialize(node.children().head, resource, identifier)
    val location = NoSourceLocationValueSerializer.deserialize(node.children()(1), resource, identifier)
    InvalidReferenceValue(reference, location)
  }
}
