package org.mule.weave.v2.compilation.mapper.nonAst

import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.UnknownLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.compilation.mapper.DWSerializer
import org.mule.weave.v2.compilation.mapper.ast.NameIdentifierSerializer
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.location.NoSourceLocation
import org.mule.weave.v2.parser.location.NoSourcePosition
import org.mule.weave.v2.parser.location.{ UnknownLocation => ParserUnkownLocation }
import org.mule.weave.v2.sdk.WeaveResource

object NoSourceLocationValueSerializer extends DWSerializer[NoSourceLocation] {
  private def isUnknownLocation(node: SerializableAstNode, resource: WeaveResource, identifier: NameIdentifier): Boolean = {
    val start = deserializeInt(node.children().head)
    val end = deserializeInt(node.children()(3))
    val nameIdentifier = NameIdentifierSerializer.deserialize(node.children()(6), resource, identifier)

    start == 0 && end == 0 && nameIdentifier == NameIdentifier.ANONYMOUS_NAME
  }

  override def serialize(value: NoSourceLocation): SerializableAstNode = {
    val children = Seq(
      serializeInt(value.startPosition.index),
      serializeInt(value.startPosition.line),
      serializeInt(value.startPosition.column),

      serializeInt(value.endPosition.index),
      serializeInt(value.endPosition.line),
      serializeInt(value.endPosition.column),

      AstToSerializableMapper.serialize(value.resourceName))
    NodeSerializableAstNode(SerializableAstNodeKind.LOCATION_VALUE_NODE, UnknownLocation, children)
  }

  override def deserialize(node: SerializableAstNode, resource: WeaveResource, identifier: NameIdentifier): NoSourceLocation = {
    if (isUnknownLocation(node, resource, identifier)) {
      NoSourceLocation.fromLocation(ParserUnkownLocation)
    } else {
      val nameIdentifier = NameIdentifierSerializer.deserialize(node.children()(6), resource, identifier)

      val sIndex = deserializeInt(node.children().head)
      val sLine = deserializeInt(node.children()(1))
      val sCol = deserializeInt(node.children()(2))

      val startPosition = NoSourcePosition(sIndex, sLine, sCol)

      val eIndex = deserializeInt(node.children()(3))
      val eLine = deserializeInt(node.children()(4))
      val eCol = deserializeInt(node.children()(5))

      val endPosition = NoSourcePosition(eIndex, eLine, eCol)

      new NoSourceLocation(startPosition, endPosition, nameIdentifier)
    }
  }
}
