package org.mule.weave.v2.compilation.mapper.nonAst

import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.UnknownLocation
import org.mule.weave.v2.compilation.exception.UnknownOperatorIdException
import org.mule.weave.v2.compilation.exception.UnknownOperatorKindException
import org.mule.weave.v2.compilation.mapper.DWSerializer
import org.mule.weave.v2.grammar.AdditionOpId
import org.mule.weave.v2.grammar.AllAttributesSelectorOpId
import org.mule.weave.v2.grammar.AllSchemaSelectorOpId
import org.mule.weave.v2.grammar.AsOpId
import org.mule.weave.v2.grammar.AttributeValueSelectorOpId
import org.mule.weave.v2.grammar.DescendantsSelectorOpId
import org.mule.weave.v2.grammar.DivisionOpId
import org.mule.weave.v2.grammar.DynamicSelectorOpId
import org.mule.weave.v2.grammar.EqOpId
import org.mule.weave.v2.grammar.FilterSelectorOpId
import org.mule.weave.v2.grammar.GreaterOrEqualThanOpId
import org.mule.weave.v2.grammar.GreaterThanOpId
import org.mule.weave.v2.grammar.IsOpId
import org.mule.weave.v2.grammar.LeftShiftOpId
import org.mule.weave.v2.grammar.LessOrEqualThanOpId
import org.mule.weave.v2.grammar.LessThanOpId
import org.mule.weave.v2.grammar.MetadataAdditionOpId
import org.mule.weave.v2.grammar.MetadataInjectorOpId
import org.mule.weave.v2.grammar.MinusOpId
import org.mule.weave.v2.grammar.MultiAttributeValueSelectorOpId
import org.mule.weave.v2.grammar.MultiValueSelectorOpId
import org.mule.weave.v2.grammar.MultiplicationOpId
import org.mule.weave.v2.grammar.NamespaceSelectorOpId
import org.mule.weave.v2.grammar.NotEqOpId
import org.mule.weave.v2.grammar.NotOpId
import org.mule.weave.v2.grammar.ObjectKeyValueSelectorOpId
import org.mule.weave.v2.grammar.OpIdentifier
import org.mule.weave.v2.grammar.RangeSelectorOpId
import org.mule.weave.v2.grammar.RightShiftOpId
import org.mule.weave.v2.grammar.SchemaValueSelectorOpId
import org.mule.weave.v2.grammar.SimilarOpId
import org.mule.weave.v2.grammar.SubtractionOpId
import org.mule.weave.v2.grammar.ValueSelectorOpId
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object OpIdSerializer extends DWSerializer[OpIdentifier] {
  override def serialize(opId: OpIdentifier): SerializableAstNode = {
    val kind = opId match {
      //UNARY
      case AllAttributesSelectorOpId       => SerializableAstNodeKind.ALL_ATTRIBUTES_SELECTOR_OP_ID_NODE
      case AllSchemaSelectorOpId           => SerializableAstNodeKind.ALL_SCHEMA_SELECTOR_OP_ID_NODE
      case DescendantsSelectorOpId         => SerializableAstNodeKind.DESCENDANTS_SELECTOR_OP_ID_NODE
      case MinusOpId                       => SerializableAstNodeKind.MINUS_OP_ID_NODE
      case NamespaceSelectorOpId           => SerializableAstNodeKind.NAMESPACE_SELECTOR_OP_ID_NODE
      case NotOpId                         => SerializableAstNodeKind.NOT_OP_ID_NODE
      //BINARY
      case AdditionOpId                    => SerializableAstNodeKind.ADDITION_OP_ID_NODE
      case AsOpId                          => SerializableAstNodeKind.AS_OP_ID_NODE
      case AttributeValueSelectorOpId      => SerializableAstNodeKind.ATTRIBUTE_VALUE_SELECTOR_OP_ID_NODE
      case DivisionOpId                    => SerializableAstNodeKind.DIVISION_OP_ID_NODE
      case DynamicSelectorOpId             => SerializableAstNodeKind.DYNAMIC_SELECTOR_OP_ID_NODE
      case EqOpId                          => SerializableAstNodeKind.EQ_OP_ID_NODE
      case FilterSelectorOpId              => SerializableAstNodeKind.FILTER_SELECTOR_OP_ID_NODE
      case GreaterOrEqualThanOpId          => SerializableAstNodeKind.GREATER_OR_EQUAL_THAN_OP_ID_NODE
      case GreaterThanOpId                 => SerializableAstNodeKind.GREATER_THAN_OP_ID_NODE
      case IsOpId                          => SerializableAstNodeKind.IS_OP_ID_NODE
      case LeftShiftOpId                   => SerializableAstNodeKind.LEFT_SHIFT_OP_ID_NODE
      case LessOrEqualThanOpId             => SerializableAstNodeKind.LESS_OR_EQUAL_THAN_OP_ID_NODE
      case LessThanOpId                    => SerializableAstNodeKind.LESS_THAN_OP_ID_NODE
      case MetadataAdditionOpId            => SerializableAstNodeKind.METADATA_ADDITION_OP_ID_NODE
      case MetadataInjectorOpId            => SerializableAstNodeKind.METADATA_INJECTOR_OP_ID_NODE
      case MultiAttributeValueSelectorOpId => SerializableAstNodeKind.MULTI_ATTRIBUTE_VALUE_SELECTOR_OP_ID_NODE
      case MultiplicationOpId              => SerializableAstNodeKind.MULTIPLICATION_OP_ID_NODE
      case MultiValueSelectorOpId          => SerializableAstNodeKind.MULTI_VALUE_SELECTOR_OP_ID_NODE
      case NotEqOpId                       => SerializableAstNodeKind.NOT_EQ_OP_ID_NODE
      case ObjectKeyValueSelectorOpId      => SerializableAstNodeKind.OBJECT_KEY_VALUE_SELECTOR_OP_ID_NODE
      case RangeSelectorOpId               => SerializableAstNodeKind.RANGE_SELECTOR_OP_ID_NODE
      case RightShiftOpId                  => SerializableAstNodeKind.RIGHT_SHIFT_OP_ID_NODE
      case SchemaValueSelectorOpId         => SerializableAstNodeKind.SCHEMA_VALUE_SELECTOR_OP_ID_NODE
      case SimilarOpId                     => SerializableAstNodeKind.SIMILAR_OP_ID_NODE
      case SubtractionOpId                 => SerializableAstNodeKind.SUBTRACTION_OP_ID_NODE
      case ValueSelectorOpId               => SerializableAstNodeKind.VALUE_SELECTOR_OP_ID_NODE
      case _                               => throw UnknownOperatorIdException(opId)
    }
    NodeSerializableAstNode(kind, UnknownLocation, Seq())
  }

  override def deserialize(node: SerializableAstNode, resource: WeaveResource, identifier: NameIdentifier): OpIdentifier = {
    node.kind() match {
      case SerializableAstNodeKind.ALL_ATTRIBUTES_SELECTOR_OP_ID_NODE => AllAttributesSelectorOpId
      case SerializableAstNodeKind.ALL_SCHEMA_SELECTOR_OP_ID_NODE => AllSchemaSelectorOpId
      case SerializableAstNodeKind.DESCENDANTS_SELECTOR_OP_ID_NODE => DescendantsSelectorOpId
      case SerializableAstNodeKind.MINUS_OP_ID_NODE => MinusOpId
      case SerializableAstNodeKind.NAMESPACE_SELECTOR_OP_ID_NODE => NamespaceSelectorOpId
      case SerializableAstNodeKind.NOT_OP_ID_NODE => NotOpId
      case SerializableAstNodeKind.ADDITION_OP_ID_NODE => AdditionOpId
      case SerializableAstNodeKind.AS_OP_ID_NODE => AsOpId
      case SerializableAstNodeKind.ATTRIBUTE_VALUE_SELECTOR_OP_ID_NODE => AttributeValueSelectorOpId
      case SerializableAstNodeKind.DIVISION_OP_ID_NODE => DivisionOpId
      case SerializableAstNodeKind.DYNAMIC_SELECTOR_OP_ID_NODE => DynamicSelectorOpId
      case SerializableAstNodeKind.EQ_OP_ID_NODE => EqOpId
      case SerializableAstNodeKind.FILTER_SELECTOR_OP_ID_NODE => FilterSelectorOpId
      case SerializableAstNodeKind.GREATER_OR_EQUAL_THAN_OP_ID_NODE => GreaterOrEqualThanOpId
      case SerializableAstNodeKind.GREATER_THAN_OP_ID_NODE => GreaterThanOpId
      case SerializableAstNodeKind.IS_OP_ID_NODE => IsOpId
      case SerializableAstNodeKind.LEFT_SHIFT_OP_ID_NODE => LeftShiftOpId
      case SerializableAstNodeKind.LESS_OR_EQUAL_THAN_OP_ID_NODE => LessOrEqualThanOpId
      case SerializableAstNodeKind.LESS_THAN_OP_ID_NODE => LessThanOpId
      case SerializableAstNodeKind.METADATA_ADDITION_OP_ID_NODE => MetadataAdditionOpId
      case SerializableAstNodeKind.METADATA_INJECTOR_OP_ID_NODE => MetadataInjectorOpId
      case SerializableAstNodeKind.MULTI_ATTRIBUTE_VALUE_SELECTOR_OP_ID_NODE => MultiAttributeValueSelectorOpId
      case SerializableAstNodeKind.MULTIPLICATION_OP_ID_NODE => MultiplicationOpId
      case SerializableAstNodeKind.MULTI_VALUE_SELECTOR_OP_ID_NODE => MultiValueSelectorOpId
      case SerializableAstNodeKind.NOT_EQ_OP_ID_NODE => NotEqOpId
      case SerializableAstNodeKind.OBJECT_KEY_VALUE_SELECTOR_OP_ID_NODE => ObjectKeyValueSelectorOpId
      case SerializableAstNodeKind.RANGE_SELECTOR_OP_ID_NODE => RangeSelectorOpId
      case SerializableAstNodeKind.RIGHT_SHIFT_OP_ID_NODE => RightShiftOpId
      case SerializableAstNodeKind.SCHEMA_VALUE_SELECTOR_OP_ID_NODE => SchemaValueSelectorOpId
      case SerializableAstNodeKind.SIMILAR_OP_ID_NODE => SimilarOpId
      case SerializableAstNodeKind.SUBTRACTION_OP_ID_NODE => SubtractionOpId
      case SerializableAstNodeKind.VALUE_SELECTOR_OP_ID_NODE => ValueSelectorOpId
      case _ => throw UnknownOperatorKindException(node.kind())
    }
  }
}