package org.mule.weave.v2.compilation.mapper.nonAst

import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.UnknownLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.compilation.mapper.DWSerializer
import org.mule.weave.v2.compilation.mapper.ast.NameIdentifierSerializer
import org.mule.weave.v2.interpreted.marker.ReferenceValue
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object ReferenceValueSerializer extends DWSerializer[ReferenceValue] {

  override def serialize(referenceVal: ReferenceValue): SerializableAstNode = {
    val refChildren = Seq(
      AstToSerializableMapper.serializeMaybe(referenceVal.moduleFQN),
      serializeString(referenceVal.localVariableName),
      NoSourceLocationValueSerializer.serializeMaybe(referenceVal.referenceLocation))
    NodeSerializableAstNode(SerializableAstNodeKind.REFERENCE_VALUE_NODE, UnknownLocation, refChildren)
  }

  override def deserialize(node: SerializableAstNode, resource: WeaveResource, identifier: NameIdentifier): ReferenceValue = {
    val moduleFQN = NameIdentifierSerializer.deserializeMaybe(node.children().head, resource, identifier)
    val localVariableName = AstToSerializableMapper.deserializeString(node.children()(1))
    val location = NoSourceLocationValueSerializer.deserializeMaybe(node.children()(2), resource, identifier)
    ReferenceValue(moduleFQN, localVariableName, location)
  }
}
