package org.mule.weave.v2.compilation.mapper.nonAst

import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.UnknownLocation
import org.mule.weave.v2.compilation.mapper.DWSerializer
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource
import org.mule.weave.v2.versioncheck.SVersion

object SVersionSerializer extends DWSerializer[SVersion] {
  override def serialize(version: SVersion): SerializableAstNode = {
    val children: Seq[SerializableAstNode] = Seq(
      serializeInt(version.mayor),
      serializeInt(version.minor),
      serializeInt(version.patch))
    NodeSerializableAstNode(SerializableAstNodeKind.SVERSION_NODE, UnknownLocation, children)
  }

  override def deserialize(node: SerializableAstNode, resource: WeaveResource, identifier: NameIdentifier): SVersion = {
    SVersion(
      deserializeInt(node.children().head),
      deserializeInt(node.children()(1)),
      deserializeInt(node.children()(2)))
  }
}
