package org.mule.weave.v2.interpreted

import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.compilation.serializer.SerializableAstNodeSerializer
import org.mule.weave.v2.parser.ast.structure.DocumentNode
import org.mule.weave.v2.parser.phase._
import org.mule.weave.v2.scope.AstNavigator
import org.mule.weave.v2.sdk.BinaryWeaveResource

import java.io.{ ByteArrayInputStream, DataInputStream }

class BinaryCompilationMappingLoaderPhase extends CompilationPhase[BinaryWeaveResource, AstNodeResultAware[DocumentNode] with AstNavigatorResultAware] {

  override def doCall(weaveResource: BinaryWeaveResource, context: ParsingContext): PhaseResult[_ <: AstNodeResultAware[DocumentNode] with AstNavigatorResultAware] = {
    val serializableAstNode = SerializableAstNodeSerializer.deserialize(new DataInputStream(new ByteArrayInputStream(weaveResource.binaryContent)))
    val documentNode = AstToSerializableMapper.deserialize(serializableAstNode, weaveResource, context.nameIdentifier).asInstanceOf[DocumentNode]
    new PhaseResult(Option.apply(new BinaryCompilationMappingResult(documentNode)), context.messageCollector)
  }

  private class BinaryCompilationMappingResult(private val documentNode: DocumentNode) extends AstNodeResultAware[DocumentNode] with AstNavigatorResultAware {
    override def astNode: DocumentNode = documentNode

    override def astNavigator: AstNavigator = AstNavigator.apply(documentNode)
  }

}

