package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.patterns.EmptyObjectPatternNode

object EmptyObjectPatternNodeSerializer extends AstNodeSerializer[EmptyObjectPatternNode] {

  override protected def doSerialize(node: EmptyObjectPatternNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val onMatch = AstToSerializableMapper.serialize(node.onMatch)
    val children: Seq[SerializableAstNode] = Seq(_annotations, onMatch)
    NodeSerializableAstNode(SerializableAstNodeKind.EMPTY_OBJECT_PATTERN_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): EmptyObjectPatternNode = {
    val onMatch = AstToSerializableMapper.deserialize(children.head, context)
    EmptyObjectPatternNode(onMatch)
  }
}
