package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.SerializerContext
import org.mule.weave.v2.parser.ast.variables.NameIdentifier

object NameIdentifierSerializer extends AstNodeSerializer[NameIdentifier] {

  override protected def doSerialize(node: NameIdentifier, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val name = serializeString(node.name)
    val loader = serializerMaybeString(node.loader)
    val children: Seq[SerializableAstNode] = Seq(_annotations, name, loader)
    NodeSerializableAstNode(SerializableAstNodeKind.NAME_IDENTIFIER_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): NameIdentifier = {
    val name = deserializeString(children.head)
    val loader = deserializeMaybeString(children(1))
    NameIdentifier(name, loader)
  }
}
