package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.types.{ FunctionTypeNode, WeaveTypeNode }

object FunctionTypeNodeSerializer extends AstNodeSerializer[FunctionTypeNode] {

  override protected def doSerialize(node: FunctionTypeNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val args = FunctionParameterTypeNodeSerializer.serializeSeq(node.args)
    val returnType = AstToSerializableMapper.serialize(node.returnType)
    val maybeSchema = SchemaNodeSerializer.serializeMaybe(node.maybeSchema)
    val maybeTypeSchema = SchemaNodeSerializer.serializeMaybe(node.maybeTypeSchema)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, args, returnType, maybeSchema, maybeTypeSchema, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.FUNCTION_TYPE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): FunctionTypeNode = {
    val args = FunctionParameterTypeNodeSerializer.deserializeSeq(children.head, context)
    val returnType = AstToSerializableMapper.deserialize(children(1), context).asInstanceOf[WeaveTypeNode]
    val maybeSchema = SchemaNodeSerializer.deserializeMaybe(children(2), context)
    val maybeTypeSchema = SchemaNodeSerializer.deserializeMaybe(children(3), context)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(4), context)
    FunctionTypeNode(args, returnType, maybeSchema, maybeTypeSchema, annotations)
  }
}
