package org.mule.weave.v2.runtime.core.functions.math

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.math
import org.mule.weave.v2.model.values.math.Number

import java.math.MathContext

object BigDecimalSqrtFunctionValue extends BaseBigDecimalUnaryFunctionValue {
  override def applyOperation(n: math.Number, context: MathContext)(implicit ctx: EvaluationContext): math.Number =
    Number(n.toBigDecimal.bigDecimal.sqrt(context))
}
