package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.SerializerContext
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode

object AnnotationNodeSerializer extends AstNodeSerializer[AnnotationNode] {

  override protected def doSerialize(node: AnnotationNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val name = NameIdentifierSerializer.serialize(node.name)
    val args = AnnotationArgumentsNodeSerializer.serializeMaybe(node.args)
    val children = Seq(_annotations, name, args)
    NodeSerializableAstNode(SerializableAstNodeKind.ANNOTATION_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): AnnotationNode = {
    val name = NameIdentifierSerializer.deserialize(children.head, context)
    val args = AnnotationArgumentsNodeSerializer.deserializeMaybe(children(1), context)
    AnnotationNode(name, args)
  }
}
