package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.structure.DocumentNode

object DocumentNodeSerializer extends AstNodeSerializer[DocumentNode] {

  override protected def doSerialize(node: DocumentNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val header = HeaderNodeSerializer.serialize(node.header)
    val root = AstToSerializableMapper.serialize(node.root)
    val children: Seq[SerializableAstNode] = Seq(_annotations, header, root)
    NodeSerializableAstNode(SerializableAstNodeKind.DOCUMENT_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): DocumentNode = {
    val header = HeaderNodeSerializer.deserialize(children.head, context)
    val body = AstToSerializableMapper.deserialize(children(1), context)
    DocumentNode(header, body)
  }
}
