package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.patterns.ExpressionPatternNode

object ExpressionPatternNodeSerializer extends AstNodeSerializer[ExpressionPatternNode] {

  override protected def doSerialize(node: ExpressionPatternNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val pattern = AstToSerializableMapper.serialize(node.pattern)
    val name = NameIdentifierSerializer.serialize(node.name)
    val onMatch = AstToSerializableMapper.serialize(node.onMatch)
    val children: Seq[SerializableAstNode] = Seq(_annotations, pattern, name, onMatch)
    NodeSerializableAstNode(SerializableAstNodeKind.EXPRESSION_PATTERN_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): ExpressionPatternNode = {
    val pattern = AstToSerializableMapper.deserialize(children.head, context)
    val name = NameIdentifierSerializer.deserialize(children(1), context)
    val onMatch = AstToSerializableMapper.deserialize(children(2), context)
    ExpressionPatternNode(pattern, name, onMatch)
  }
}
