package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.functions.FunctionNode
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode

object FunctionNodeSerializer extends AstNodeSerializer[FunctionNode] {

  override protected def doSerialize(node: FunctionNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val params = FunctionParametersSerializer.serialize(node.params)
    val body = AstToSerializableMapper.serialize(node.body)
    val returnType = AstToSerializableMapper.serializeMaybe(node.returnType)
    val typeParameterList = TypeParametersListNodeSerializer.serializeMaybe(node.typeParameterList)
    val children: Seq[SerializableAstNode] = Seq(_annotations, params, body, returnType, typeParameterList)
    NodeSerializableAstNode(SerializableAstNodeKind.FUNCTION_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): FunctionNode = {
    val params = FunctionParametersSerializer.deserialize(children.head, context)
    val body = AstToSerializableMapper.deserialize(children(1), context)
    val returnType = AstToSerializableMapper.deserializeMaybe(children(2), context).asInstanceOf[Option[WeaveTypeNode]]
    val typeParameterList = TypeParametersListNodeSerializer.deserializeMaybe(children(3), context)
    FunctionNode(params, body, returnType, typeParameterList)
  }
}
