package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.types.{ KeyValueTypeNode, WeaveTypeNode }

object KeyValueTypeNodeSerializer extends AstNodeSerializer[KeyValueTypeNode] {

  override protected def doSerialize(node: KeyValueTypeNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val key = AstToSerializableMapper.serialize(node.key)
    val value = AstToSerializableMapper.serialize(node.value)
    val repeated = serializeBoolean(node.repeated)
    val optional = serializeBoolean(node.optional)
    val children: Seq[SerializableAstNode] = Seq(_annotations, key, value, repeated, optional)
    NodeSerializableAstNode(SerializableAstNodeKind.KEY_VALUE_TYPE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): KeyValueTypeNode = {
    val key = AstToSerializableMapper.deserialize(children.head, context).asInstanceOf[WeaveTypeNode]
    val value = AstToSerializableMapper.deserialize(children(1), context).asInstanceOf[WeaveTypeNode]
    val repeated = deserializeBoolean(children(2))
    val optional = deserializeBoolean(children(3))
    KeyValueTypeNode(key, value, repeated, optional)
  }
}
