package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.structure.NameNode

object NameNodeSerializer extends AstNodeSerializer[NameNode] {

  override protected def doSerialize(node: NameNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val keyName = AstToSerializableMapper.serialize(node.keyName)
    val ns = AstToSerializableMapper.serializeMaybe(node.ns)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, keyName, ns, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.NAME_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): NameNode = {
    val keyName = AstToSerializableMapper.deserialize(children.head, context)
    val ns = AstToSerializableMapper.deserializeMaybe(children(1), context)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(2), context)
    NameNode(keyName, ns, annotations)
  }
}
