package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.SerializerContext
import org.mule.weave.v2.parser.ast.types.NameTypeNode

object NameTypeNodeSerializer extends AstNodeSerializer[NameTypeNode] {

  override protected def doSerialize(node: NameTypeNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val localName = serializerMaybeString(node.localName)
    val ns = NamespaceNodeSerializer.serializeMaybe(node.ns)
    val maybeTypeSchema = SchemaNodeSerializer.serializeMaybe(node.maybeTypeSchema)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, localName, ns, maybeTypeSchema, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.NAME_TYPE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): NameTypeNode = {
    val localName = deserializeMaybeString(children.head)
    val ns = NamespaceNodeSerializer.deserializeMaybe(children(1), context)
    val maybeTypeSchema = SchemaNodeSerializer.deserializeMaybe(children(2), context)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(3), context)
    NameTypeNode(localName, ns, maybeTypeSchema, annotations)
  }
}
