package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.conditional.UnlessNode

object UnlessNodeSerializer extends AstNodeSerializer[UnlessNode] {

  override protected def doSerialize(node: UnlessNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val ifExpr = AstToSerializableMapper.serialize(node.ifExpr)
    val condition = AstToSerializableMapper.serialize(node.condition)
    val elseExpr = AstToSerializableMapper.serialize(node.elseExpr)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, ifExpr, condition, elseExpr, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.UNLESS_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): UnlessNode = {
    val ifExpr = AstToSerializableMapper.deserialize(children.head, context)
    val condition = AstToSerializableMapper.deserialize(children(1), context)
    val elseExpr = AstToSerializableMapper.deserialize(children(2), context)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(3), context)
    UnlessNode(ifExpr, condition, elseExpr, annotations)
  }
}
