package org.mule.weave.v2.interpreted.debugger.server

import org.mule.weave.v2.debugger.WeaveBreakpoint
import org.mule.weave.v2.debugger.WeaveExceptionBreakpoint
import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.BooleanType
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.ast.WeaveLocationCapable
import org.mule.weave.v2.parser.location.Position

import scala.collection._

class DefaultWeaveBreakpointManager(session: DefaultWeaveDebuggingSession) extends WeaveBreakpointManager {

  var breakpoints: mutable.HashSet[WeaveBreakpoint] = mutable.HashSet[WeaveBreakpoint]()
  var exceptionBreakpoints: mutable.HashSet[WeaveExceptionBreakpoint] = mutable.HashSet[WeaveExceptionBreakpoint]()

  def hasBreakpointOn(locationCapable: WeaveLocationCapable)(implicit ctx: ExecutionContext): Boolean = {
    val breakpoint = breakpoints.find((breakpoint) => {
      val thelocation = locationCapable.location()
      if (thelocation.resourceName.name == breakpoint.nameIdentifier) {
        val startPosition: Position = thelocation.startPosition
        if (breakpoint.column != -1) {
          breakpoint.lineNumber == startPosition.line && breakpoint.column == startPosition.column
        } else {
          breakpoint.lineNumber == startPosition.line
        }
      } else {
        false
      }
    })

    breakpoint.exists((breakpoint) => {
      breakpoint.condition == null || {
        try {
          val evaluate: (EvaluationContext, Value[_]) = session.getWeaveDebuggerExecutor().evaluate(breakpoint.condition, -1, ctx)
          BooleanType.coerce(evaluate._2).evaluate
        } catch {
          case e: Exception => {
            false
          }
        }
      }
    })
  }

  def addBreakpoint(breakpoint: WeaveBreakpoint): Unit = {
    breakpoints += breakpoint
  }

  def removeBreakpoint(breakpoint: WeaveBreakpoint): Unit = {
    breakpoints -= breakpoint
  }

  def clearBreakpoints(): Unit = {
    breakpoints.clear()
    exceptionBreakpoints.clear()
  }

  override def hasExceptionBreakpoint(e: Exception): Boolean = {
    exceptionBreakpoints.exists((eb) => {
      eb.exceptionName == null || e.getClass.getSimpleName == eb.exceptionName
    })
  }

  override def addExceptionBreakpoint(exceptionBreakpoint: WeaveExceptionBreakpoint): Unit = {
    exceptionBreakpoints.+=(exceptionBreakpoint)
  }

  override def removeExceptionBreakpoint(e: WeaveExceptionBreakpoint): Unit = {
    exceptionBreakpoints -= (e)
  }
}
