package org.mule.weave.v2.interpreted.node.structure.header.directives

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.node.NameSlot
import org.mule.weave.v2.interpreted.node.ValueNode

final class VarDirective(val variable: NameSlot, val literal: ValueNode[_], val materialize: Boolean) extends Directive with Product2[NameSlot, ValueNode[_]] {

  override def execute(implicit ctx: ExecutionContext): Unit = {
    val value = if (materialize) {
      literal.execute.materialize
    } else {
      literal.execute
    }
    ctx.executionStack().setVariable(variable.slot, value)
  }

  override def _1: NameSlot = variable

  override def _2: ValueNode[_] = literal
}
