package org.mule.weave.v2.runtime.core.functions.math

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.math
import org.mule.weave.v2.model.values.math.Number

import java.math.MathContext

object BigDecimalMultiplicationFunctionValue extends BaseBigDecimalBinaryFunctionValue {
  override def applyOperation(leftFactor: math.Number, rightFactor: math.Number, context: MathContext)(implicit ctx: EvaluationContext): math.Number =
    Number(leftFactor.toBigDecimal.bigDecimal.multiply(rightFactor.toBigDecimal.bigDecimal, context))
}
