package org.mule.weave.v2.runtime.core.functions.stringops

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.NumberType
import org.mule.weave.v2.model.types.StringType
import org.mule.weave.v2.model.values._
import org.mule.weave.v2.runtime.core.exception.EmptyStringException
import org.mule.weave.v2.runtime.core.exception.InvalidUnicodeCodePointException

object CharCodeFunctionValue extends UnaryFunctionValue {
  override val R = StringType

  override def doExecute(v: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val content: String = v.evaluate.toString
    if (content.isEmpty) {
      throw new EmptyStringException(this.location())
    }
    NumberValue(content.codePointAt(0))
  }
}

object FromCharCodeFunctionValue extends UnaryFunctionValue {
  override val R = NumberType

  override def doExecute(v: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    if (ctx.serviceManager.settingsService.execution().surrogateCharCodeSupport) {
      val codePoint: Int = v.evaluate.toInt
      try {
        val chars = Character.toChars(codePoint)
        StringValue(new String(chars))
      } catch {
        case e: IllegalArgumentException => throw new InvalidUnicodeCodePointException(codePoint, e.getMessage, this.location())
      }
    } else {
      StringValue(v.evaluate.toInt.toChar.toString)
    }
  }
}
