package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.structure.KeyNode

object KeyNodeSerializer extends AstNodeSerializer[KeyNode] {

  override protected def doSerialize(node: KeyNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val keyName = AstToSerializableMapper.serialize(node.keyName)
    val ns = AstToSerializableMapper.serializeMaybe(node.ns)
    val attr = AstToSerializableMapper.serializeMaybe(node.attr)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, keyName, ns, attr, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.KEY_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): KeyNode = {
    val keyName = AstToSerializableMapper.deserialize(children.head, context)
    val ns = AstToSerializableMapper.deserializeMaybe(children(1), context)
    val attr = AstToSerializableMapper.deserializeMaybe(children(2), context)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(3), context)
    KeyNode(keyName, ns, attr, annotations)
  }
}
