package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.SerializerContext
import org.mule.weave.v2.parser.ast.header.directives.VersionMinor

object VersionMinorSerializer extends AstNodeSerializer[VersionMinor] {

  override protected def doSerialize(node: VersionMinor, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val children: Seq[SerializableAstNode] = Seq(_annotations, serializeString(node.v))
    NodeSerializableAstNode(SerializableAstNodeKind.VERSION_MINOR_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): VersionMinor = {
    val v = deserializeString(children.head)
    VersionMinor(v)
  }
}
