package org.mule.weave.v2.compilation.mapper.nonAst

import org.mule.weave.v2.compilation.{ NodeSerializableAstNode, SerializableAstNode, SerializableAstNodeKind, UnknownLocation }
import org.mule.weave.v2.compilation.mapper.ast.NameIdentifierSerializer
import org.mule.weave.v2.compilation.mapper.{ DWSerializer, SerializerContext }
import org.mule.weave.v2.interpreted.marker.InvalidReferenceValue

object InvalidReferenceValueSerializer extends DWSerializer[InvalidReferenceValue] {

  override def serialize(invalidReference: InvalidReferenceValue): SerializableAstNode = {
    val children = Seq(
      NameIdentifierSerializer.serialize(invalidReference.reference),
      NoSourceLocationValueSerializer.serialize(invalidReference.location))
    NodeSerializableAstNode(SerializableAstNodeKind.INVALID_REFERENCE_VALUE_NODE, UnknownLocation, children)
  }

  override def deserialize(node: SerializableAstNode, context: SerializerContext): InvalidReferenceValue = {
    val reference = NameIdentifierSerializer.deserialize(node.children().head, context)
    val location = NoSourceLocationValueSerializer.deserialize(node.children()(1), context)
    InvalidReferenceValue(reference, location)
  }
}
