package org.mule.weave.v2.interpreted

import org.mule.weave.v2.compilation.mapper.ResourceBasedSerializerContext
import org.mule.weave.v2.compilation.mapper.ast.ModuleNodeSerializer
import org.mule.weave.v2.compilation.message.WeaveBinaryDeserializationError
import org.mule.weave.v2.compilation.serializer.SerializableAstNodeSerializer
import org.mule.weave.v2.parser.MessageCollector
import org.mule.weave.v2.parser.ast.module.ModuleNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.location.UnknownLocation
import org.mule.weave.v2.parser.phase._
import org.mule.weave.v2.scope.AstNavigator
import org.mule.weave.v2.sdk.BinaryWeaveResource

import java.io.{ ByteArrayInputStream, DataInputStream }

class BinaryCompilationModuleLoaderPhase extends CompilationPhase[(NameIdentifier, BinaryWeaveResource), AstNodeResultAware[ModuleNode] with AstNavigatorResultAware] {

  override def doCall(tuple: (NameIdentifier, BinaryWeaveResource), context: ParsingContext): PhaseResult[_ <: AstNodeResultAware[ModuleNode] with AstNavigatorResultAware] = {
    val (identifier, resource) = tuple
    try {
      val serializableAstNode = SerializableAstNodeSerializer.deserialize(new DataInputStream(new ByteArrayInputStream(tuple._2.binaryContent)))
      val moduleNode = ModuleNodeSerializer.deserialize(serializableAstNode, ResourceBasedSerializerContext(resource, identifier))
      new PhaseResult(Option.apply(new BinaryCompilationModuleResult(moduleNode)), context.messageCollector)
    } catch {
      case e: Throwable => new PhaseResult(None, MessageCollector().error(WeaveBinaryDeserializationError(identifier, e.getMessage), UnknownLocation))
    }
  }

  private class BinaryCompilationModuleResult(private val moduleNode: ModuleNode) extends AstNodeResultAware[ModuleNode] with AstNavigatorResultAware {
    override def astNode: ModuleNode = moduleNode

    override def astNavigator: AstNavigator = AstNavigator.apply(moduleNode)
  }

}