package org.mule.weave.v2.interpreted.contribution

import org.mule.weave.v2.core.env.WeaveRuntime
import org.mule.weave.v2.interpreted.api.contribution.JavaBasedDataWeaveFunction
import org.mule.weave.v2.interpreted.api.contribution.JavaBasedDataWeaveFunctionValueProvider
import org.mule.weave.v2.parser.ast.variables.NameIdentifier

object JavaBasedDataWeaveFunctionManager {

  private lazy val functions: Map[NameIdentifier, JavaBasedDataWeaveFunctionWithModule] = {
    WeaveRuntime
      .getServiceProvider()
      .serviceImplementations(classOf[JavaBasedDataWeaveFunctionValueProvider])
      .flatMap(p => p.functions
        .map(fn => {
          val moduleIdentifier = NameIdentifier(p.moduleFQNIdentifier)
          val fqn = getFunctionFQNIdentifier(moduleIdentifier, fn.functionName)
          (fqn, JavaBasedDataWeaveFunctionWithModule(moduleIdentifier, fn))
        }))
      .toMap
  }

  private def getFunctionFQNIdentifier(moduleIdentifier: NameIdentifier, functionName: String): NameIdentifier = {
    moduleIdentifier.::(functionName)
  }

  def getFunction(module: NameIdentifier, functionName: String): Option[JavaBasedDataWeaveFunctionWithModule] = {
    val fqn = getFunctionFQNIdentifier(module, functionName)
    functions.get(fqn)
  }
}

case class JavaBasedDataWeaveFunctionWithModule(functionFQNIdentifier: NameIdentifier, fn: JavaBasedDataWeaveFunction)
