package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.patterns.DeconstructArrayPatternNode

object DeconstructArrayPatternNodeSerializer extends AstNodeSerializer[DeconstructArrayPatternNode] {

  override protected def doSerialize(node: DeconstructArrayPatternNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val head = NameIdentifierSerializer.serialize(node.head)
    val tail = NameIdentifierSerializer.serialize(node.tail)
    val onMatch = AstToSerializableMapper.serialize(node.onMatch)
    val children: Seq[SerializableAstNode] = Seq(_annotations, head, tail, onMatch)
    NodeSerializableAstNode(SerializableAstNodeKind.DECONSTRUCT_ARRAY_PATTERN_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): DeconstructArrayPatternNode = {
    val head = NameIdentifierSerializer.deserialize(children.head, context)
    val tail = NameIdentifierSerializer.deserialize(children(1), context)
    val onMatch = AstToSerializableMapper.deserialize(children(2), context)
    DeconstructArrayPatternNode(head, tail, onMatch)
  }
}
