package org.mule.weave.v2.interpreted.contribution

import org.mule.weave.v2.core.env.WeaveRuntime
import org.mule.weave.v2.interpreted.node.ValueNode
import org.mule.weave.v2.interpreted.node.structure.function.FunctionParameterNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.location.WeaveLocation

trait FunctionBodyExpressionNodeContribution {
  def getFunctionBodyExpressionNode(module: NameIdentifier, function: String, parameters: Array[FunctionParameterNode], location: WeaveLocation): Option[ValueNode[Any]]
}

object FunctionBodyExpressionNodeContributionManager {

  private lazy val contributors: Seq[FunctionBodyExpressionNodeContribution] = WeaveRuntime
    .getServiceProvider()
    .serviceImplementations(classOf[FunctionBodyExpressionNodeContribution])

  def getFunctionBodyExpressionNode(module: NameIdentifier, function: String, parameters: Array[FunctionParameterNode], location: WeaveLocation): Option[ValueNode[Any]] = {
    val it = contributors.iterator
    var valueNode: ValueNode[Any] = null
    while (valueNode == null && it.hasNext) {
      val contributor = it.next()
      val maybeValueNode = contributor.getFunctionBodyExpressionNode(module, function, parameters, location)
      if (maybeValueNode.isDefined) {
        valueNode = maybeValueNode.get
      }
    }
    Option(valueNode)
  }
}

