package org.mule.weave.v2.interpreted.node.structure

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.node.ValueNode
import org.mule.weave.v2.interpreted.node.structure.header.HeaderNode
import org.mule.weave.v2.interpreted.node.structure.header.directives.ImportDirective
import org.mule.weave.v2.model.service.DefaultSecurityManagerService
import org.mule.weave.v2.model.service.WeaveRuntimePrivilege
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.ast.WeaveLocationCapable

class DocumentNode(val importedModules: Array[ImportDirective], val header: HeaderNode, val body: ValueNode[_], val maybePrivileges: Option[Seq[String]] = None) extends ValueNode[Any] with Product2[HeaderNode, ValueNode[_]] with WeaveLocationCapable {
  override def _1: HeaderNode = header

  override def _2: ValueNode[_] = body

  override def doExecute(implicit ctx: ExecutionContext): Value[_] = {
    if (maybePrivileges.isDefined) {
      val privileges = maybePrivileges.get
      val weaveRuntimePrivileges = privileges.map(WeaveRuntimePrivilege(_)).toArray
      val securityManagerService = new DefaultSecurityManagerService(weaveRuntimePrivileges)
      ctx.serviceManager.setLocalSecurityManager(securityManagerService)
    }
    var i = 0
    while (i < importedModules.length) {
      importedModules(i).execute
      i = i + 1
    }
    header.execute
    body.execute
  }
}
