package org.mule.weave.v2.interpreted.transform

import org.mule.weave.v2.interpreted.node.structure.schema.SchemaNode
import org.mule.weave.v2.interpreted.node.structure.schema.SchemaPropertyNode
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.utils.ExplicitSchemaNode
import org.mule.weave.v2.utils.SchemaNodeOrigin

trait EngineSchemaTransformations extends AstTransformation {

  def transformSchemaPropertyNode(name: AstNode, value: AstNode, condition: Option[AstNode]): SchemaPropertyNode = {
    SchemaPropertyNode(transform(name), transform(value), transformOption(condition))
  }

  def transformSchemaNode(properties: Seq[AstNode], annotationSchemaNode: SchemaNodeOrigin = ExplicitSchemaNode): SchemaNode = SchemaNode(transformSeq(properties), annotationSchemaNode)
}

