package org.mule.weave.v2.runtime.tools

import java.io.BufferedWriter
import java.io.File
import java.io.FileWriter

import org.mule.weave.v2.interpreted.RuntimeModuleNodeCompiler
import org.mule.weave.v2.interpreted.extension.ParsingContextCreator
import org.mule.weave.v2.interpreted.extension.WeaveBasedDataFormatExtensionLoaderService
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.ServiceManager
import org.mule.weave.v2.model.service.DefaultLoggingService
import org.mule.weave.v2.module.CompositeDataFormatExtensionsLoaderService
import org.mule.weave.v2.module.DataFormatExtensionsLoaderService
import org.mule.weave.v2.module.DataFormatManager
import org.mule.weave.v2.module.DefaultDataFormatExtensionsLoaderService
import org.mule.weave.v2.module.option.ModuleOption
import org.mule.weave.v2.parser.phase.ModuleParsingPhasesManager
import org.mule.weave.v2.sdk.ClassLoaderWeaveResourceResolver
import org.mule.weave.v2.sdk.ParsingContextFactory

object DataFormatJsonGenerator {

  def emitModuleOption(option: ModuleOption): StringBuilder = {
    val moduleOption = new StringBuilder()
    moduleOption.append("{\n")
    moduleOption.append(s" ${emitValue("name")}: ${emitValue(option.name)}, \n")
    moduleOption.append(s" ${emitValue("description")}: ${emitValue(option.description)}, \n")
    moduleOption.append(s" ${emitValue("type")}: ${emitValue(option.dataType)},\n")
    moduleOption.append(s" ${emitValue("defaultValue")}: ${emitValue(option.defaultValue)},\n")
    moduleOption.append(" \"possibleValue\": ").append("[")
      .append(
        option.possibleValues.map((v) => emitValue(v)).mkString(","))
      .append("]\n")
    moduleOption.append("}")
  }

  private def emitValue(v: Any): String = {
    if (v == null) {
      "null"
    } else {
      v match {
        case b: Boolean => b.toString
        case n: Number  => n.toString
        case n: Int     => n.toString
        case n: Long    => n.toString
        case _ => "\"" + v.toString
          .replace("\\", "\\\\")
          .replace("\"", "\\\"")
          .replace("\n", "\\n") + "\""
      }
    }
  }

  def main(args: Array[String]): Unit = {
    val muleSdkParserManager = ModuleParsingPhasesManager(ParsingContextFactory.createDefaultModuleLoaderManager())

    val loaderService = WeaveBasedDataFormatExtensionLoaderService(ParsingContextCreator(muleSdkParserManager), ClassLoaderWeaveResourceResolver.noContextClassloader(), RuntimeModuleNodeCompiler())
    val manager = ServiceManager(
      DefaultLoggingService,
      Map(
        //Map Of Services
        classOf[DataFormatExtensionsLoaderService] -> CompositeDataFormatExtensionsLoaderService(DefaultDataFormatExtensionsLoaderService, loaderService)))
    val evaluationContext: EvaluationContext = EvaluationContext(manager)
    val modules = DataFormatManager.modules(evaluationContext)
    val result = new StringBuilder()
    result.append("[")
    result.append(
      modules.map((data_format) => {
        val dataFormat = new StringBuilder()
        dataFormat.append("{\n")
        dataFormat.append(s" ${emitValue("name")}:${emitValue(data_format.name())},\n")
        dataFormat.append(" \"mimeTypes\": [").append(data_format.acceptedMimeTypes.map("\"" + _.toString + "\"").mkString(",")).append("],\n")
        dataFormat.append(" \"readerOptions\": [\n")
          .append(
            data_format.readerOptions().values.map((option) => s"${emitModuleOption(option)}").mkString(",\n"))
          .append("],\n")
        dataFormat.append("  \"writerOptions\":[\n")
          .append(
            data_format.writerOptions().values.map((option) => s"${emitModuleOption(option)}").mkString(",\n"))
          .append("]\n")
        dataFormat.append("}\n")
      })
        .mkString(",\n"))
    result.append("]")

    if (args.length == 0) {
      print(result)
    } else {
      val writer = new BufferedWriter(new FileWriter(new File(args(0))))
      try {
        writer.write(result.toString())
      } finally {
        writer.close()
      }
    }
  }

}
