package org.mule.weave.v2.compilation

object SerializableAstNodeKind {
  // Value Node
  val STRING_VALUE_NODE: Short = 1001
  val BOOLEAN_VALUE_NODE: Short = 1002
  val INT_VALUE_NODE: Short = 1003
  val NONE_VALUE_NODE: Short = 1004
  // Control Node
  val ARRAY_NODE: Short = 2001
  val DO_BLOCK_NODE: Short = 2002
  val NULL_SAFE_NODE: Short = 2003
  val NULL_UNSAFE_NODE: Short = 2004
  val CONDITIONAL_NODE: Short = 2005
  val IF_NODE: Short = 2006
  val UNLESS_NODE: Short = 2007

  //
  val BOOL_NODE: Short = 14
  val DATE_TIME_NODE: Short = 15
  val LOCAL_DATE_NODE: Short = 16
  val LOCAL_DATE_TIME_NODE: Short = 17
  val LOCAL_TIME_NODE: Short = 18
  val NULL_NODE: Short = 19
  val NUMBER_NODE: Short = 20
  val PERIOD_NODE: Short = 21
  val REGEX_NODE: Short = 23
  val STRING_NODE: Short = 24
  val TIME_NODE: Short = 25
  val TIME_ZONE_NODE: Short = 26
  val URI_NODE: Short = 27
  val ARRAY_LITERAL_NODE: Short = 28
  val OBJECT_LITERAL_NODE: Short = 29
  val KEY_VALUE_PAIR_NODE: Short = 30
  val KEY_NODE: Short = 31
  val NAME_NODE: Short = 32
  val ANNOTATION_PARAMETERS_NODE: Short = 33
  val ANNOTATION_PARAMETER_NODE: Short = 34
  val UNARY_OP_NODE: Short = 35
  val BINARY_OP_NODE: Short = 36
  val AND_NODE: Short = 37
  val OR_NODE: Short = 38
  val MODULE_NODE: Short = 39
  val DYNAMIC_KEY_NODE: Short = 40
  val FUNCTION_NODE: Short = 41
  val FUNCTION_PARAMETERS_NODE: Short = 42
  val FUNCTION_PARAMETER_NODE: Short = 43
  val TYPE_PARAMETERS_LIST_NODE: Short = 44
  val SCHEMA_NODE: Short = 45
  val SCHEMA_PROPERTY_NODE: Short = 46
  val VARIABLE_REFERENCE_NODE: Short = 47
  val NAME_IDENTIFIER_NODE: Short = 48
  val FUNCTION_CALL_NODE: Short = 49
  val FUNCTION_CALL_PARAMETERS_NODE: Short = 50
  val TYPE_PARAMETERS_APPLICATION_LIST_NODE: Short = 51
  val CONTENT_TYPE_NODE: Short = 52
  val DATA_FORMAT_ID_NODE: Short = 53
  val NAMESPACE_NODE: Short = 54
  val HEAD_TAIL_ARRAY_NODE: Short = 55
  val HEAD_TAIL_OBJECT_NODE: Short = 56
  val STRING_INTERPOLATION_NODE: Short = 57
  val ANNOTATION_NODE: Short = 58
  val ANNOTATION_ARGUMENTS_NODE: Short = 59
  val ANNOTATION_ARGUMENT_NODE: Short = 60
  val ATTRIBUTES_NODE: Short = 61
  val NAME_VALUE_PAIR_NODE: Short = 62
  val PATTERN_MATCHER_NODE: Short = 63
  val PATTERN_EXPRESSIONS_NODE: Short = 64
  val DECONSTRUCT_ARRAY_PATTERN_NODE: Short = 65
  val DECONSTRUCT_OBJECT_PATTERN_NODE: Short = 66
  val DEFAULT_PATTERN_NODE: Short = 67
  val EMPTY_ARRAY_PATTERN_NODE: Short = 68
  val EMPTY_OBJECT_PATTERN_NODE: Short = 69
  val EXPRESSION_PATTERN_NODE: Short = 70
  val LITERAL_PATTERN_NODE: Short = 71
  val REGEX_PATTERN_NODE: Short = 72
  val TYPE_PATTERN_NODE: Short = 73
  val USING_NODE: Short = 74
  val USING_VARIABLE_ASSIGNMENTS_NODE: Short = 75
  val USING_VARIABLE_ASSIGNMENT_NODE: Short = 76
  val DEFAULT_NODE: Short = 77
  val UPDATE_NODE: Short = 78
  val UPDATE_EXPRESSIONS_NODE: Short = 79
  val UPDATE_EXPRESSION_NODE: Short = 80
  val ARRAY_INDEX_UPDATE_SELECTOR_NODE: Short = 81
  val ATTRIBUTE_NAME_UPDATE_SELECTOR_NODE: Short = 82
  val FIELD_NAME_UPDATE_SELECTOR_NODE: Short = 83
  val MULTI_FIELD_NAME_UPDATE_SELECTOR_NODE: Short = 84
  val EXISTS_SELECTOR_NODE: Short = 85
  val DYNAMIC_NAME_NODE: Short = 86
  val OVERLOADED_FUNCTION_NODE: Short = 87
  val UNDEFINED_EXPRESSION_NODE: Short = 88

  //Unary op ids
  val ALL_ATTRIBUTES_SELECTOR_OP_ID_NODE: Short = 3001
  val ALL_SCHEMA_SELECTOR_OP_ID_NODE: Short = 3002
  val DESCENDANTS_SELECTOR_OP_ID_NODE: Short = 3003
  val MINUS_OP_ID_NODE: Short = 3004
  val NAMESPACE_SELECTOR_OP_ID_NODE: Short = 3005
  val NOT_OP_ID_NODE: Short = 3006

  //Binary op ids
  val ADDITION_OP_ID_NODE: Short = 4001
  val AS_OP_ID_NODE: Short = 4002
  val ATTRIBUTE_VALUE_SELECTOR_OP_ID_NODE: Short = 4003
  val DIVISION_OP_ID_NODE: Short = 4004
  val DYNAMIC_SELECTOR_OP_ID_NODE: Short = 4005
  val EQ_OP_ID_NODE: Short = 4006
  val FILTER_SELECTOR_OP_ID_NODE: Short = 4007
  val GREATER_OR_EQUAL_THAN_OP_ID_NODE: Short = 4008
  val GREATER_THAN_OP_ID_NODE: Short = 4009
  val IS_OP_ID_NODE: Short = 4010
  val LEFT_SHIFT_OP_ID_NODE: Short = 4011
  val LESS_OR_EQUAL_THAN_OP_ID_NODE: Short = 4012
  val LESS_THAN_OP_ID_NODE: Short = 4013
  val METADATA_ADDITION_OP_ID_NODE: Short = 4014
  val METADATA_INJECTOR_OP_ID_NODE: Short = 4015
  val MULTI_ATTRIBUTE_VALUE_SELECTOR_OP_ID_NODE: Short = 4016
  val MULTIPLICATION_OP_ID_NODE: Short = 4017
  val MULTI_VALUE_SELECTOR_OP_ID_NODE: Short = 4018
  val NOT_EQ_OP_ID_NODE: Short = 4019
  val OBJECT_KEY_VALUE_SELECTOR_OP_ID_NODE: Short = 4020
  val RANGE_SELECTOR_OP_ID_NODE: Short = 4021
  val RIGHT_SHIFT_OP_ID_NODE: Short = 4022
  val SCHEMA_VALUE_SELECTOR_OP_ID_NODE: Short = 4023
  val SIMILAR_OP_ID_NODE: Short = 4024
  val SUBTRACTION_OP_ID_NODE: Short = 4025
  val VALUE_SELECTOR_OP_ID_NODE: Short = 4026

  //AST ANNOTATIONS
  val DESCENDANTS_INCLUDE_THIS_ANNOTATION_NODE: Short = 5001
  val INJECTED_NODE_ANNOTATION_NODE: Short = 5002
  val TAIL_REC_FUNCTION_ANNOTATION_NODE: Short = 5003
  val MATERIALIZE_VARIABLE_ANNOTATION_NODE: Short = 5004
  val SINCE_AST_NODE_ANNOTATION_NODE: Short = 5005
  val STREAMING_CAPABLE_VARIABLE_ANNOTATION_NODE: Short = 5006
  val CONSTANT_ARGUMENT_ANNOTATION_NODE: Short = 5007
  val DO_BLOCK_NODE_NODE_NON_SHADOWED_VARIABLES_ANNOTATION_NODE: Short = 5008
  val LAZY_VAR_DIRECTIVE_ANNOTATION_NODE: Short = 5009
  val LITERAL_NODE_ANNOTATION_NODE: Short = 5010
  val NATIVE_FUNCTION_ANNOTATION_NODE: Short = 5011
  val OVERLOADED_FUNCTION_NOT_CACHEABLE_ANNOTATION_NODE: Short = 5012
  val PARAMETER_REFERENCE_FUNCTION_CALL_ARGUMENT_ANNOTATION_NODE: Short = 5013
  val REQUIRES_MATERIALIZATION_ANNOTATION_NODE: Short = 5014
  val STATIC_REC_FUNCTION_CALL_ANNOTATION_NODE: Short = 5015
  val TYPE_PARAMETER_NODE_ANNOTATION_NODE: Short = 5016
  val EXTERNAL_BINDING_ANNOTATION_NODE: Short = 5017
  val FUNCTION_CALL_NAME_ANNOTATION_NODE: Short = 5018
  val INTERCEPTOR_INVALID_REFERENCE_ANNOTATION_NODE: Short = 5019
  val INTERCEPTOR_ON_NATIVE_FUNCTION_ANNOTATION: Short = 5020
  val INTERCEPTOR_ON_REFERENCE_ANNOTATION_NODE: Short = 5021
  val REFERENCE_ANNOTATION_NODE: Short = 5022
  val STATIC_FUNCTION_CALL_ANNOTATION_NODE: Short = 5023
  val UNTRUSTED_CODE_AST_NODE_ANNOTATION: Short = 5024
  val TAIL_REC_FUNCTION_CALL_ANNOTATION_NODE: Short = 5025
  val QUOTED_STRING_ANNOTATION_NODE: Short = 5026
  val MATERIALIZE_TYPE_ANNOTATION_NODE: Short = 5027
  val SVERSION_NODE: Short = 5028
  val INVALID_REFERENCE_VALUE_NODE: Short = 5029
  val INTERCEPTOR_NATIVE_FUNCTION_VALUE_NODE: Short = 5030
  val REFERENCE_VALUE_NODE: Short = 5031
  val LOCATION_VALUE_NODE: Short = 5032
  val DATA_FORMAT_EXTENSION_ANNOTATION_NODE: Short = 5033
  val DATA_FORMAT_SETTINGS_VALUE_NODE: Short = 5034
  val DATA_FORMAT_STRING_SETTING_VALUE_NODE: Short = 5035
  val DATA_FORMAT_BOOLEAN_SETTING_VALUE_NODE: Short = 5036
  val DATA_FORMAT_INT_SETTING_VALUE_NODE: Short = 5037

  // Directives
  val DOCUMENT_NODE: Short = 6001
  val HEADER_NODE: Short = 6002
  val ANNOTATION_DIRECTIVE_NODE: Short = 6003
  val FUNCTION_DIRECTIVE_NODE: Short = 6004
  val IMPORT_DIRECTIVE_NODE: Short = 6005
  val INPUT_DIRECTIVE_NODE: Short = 6006
  val OUTPUT_DIRECTIVE_NODE: Short = 6007
  val NAMESPACE_DIRECTIVE_NODE: Short = 6008
  val TYPE_DIRECTIVE_NODE: Short = 6009
  val VAR_DIRECTIVE_NODE: Short = 6010
  val VERSION_DIRECTIVE_NODE: Short = 6011
  val VERSION_MAJOR_NODE: Short = 6012
  val VERSION_MINOR_NODE: Short = 6013
  val DIRECTIVE_OPTION_NODE: Short = 6014
  val DIRECTIVE_OPTION_NAME_NODE: Short = 6015
  val IMPORTED_ELEMENTS_NODE: Short = 6016
  val IMPORTED_ELEMENT_NODE: Short = 6017

  //Types
  val DYNAMIC_RETURN_TYPE_NODE: Short = 7001
  val FUNCTION_PARAMETER_TYPE_NODE: Short = 7002
  val KEY_VALUE_TYPE_NODE: Short = 7003
  val NAME_VALUE_TYPE_NODE: Short = 7004
  val NATIVE_TYPE_NODE: Short = 7005
  val TYPE_PARAMETER_NODE: Short = 7006
  val FUNCTION_TYPE_NODE: Short = 7007
  val INTERSECTION_TYPE_NODE: Short = 7008
  val KEY_TYPE_NODE: Short = 7009
  val LITERAL_TYPE_NODE: Short = 7010
  val NAME_TYPE_NODE: Short = 7011
  val OBJECT_TYPE_NODE: Short = 7012
  val TYPE_REFERENCE_NODE: Short = 7013
  val TYPE_SELECTOR_NODE: Short = 7014
  val UNION_TYPE_NODE: Short = 7015
}
