package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.types.{ TypeParametersApplicationListNode, WeaveTypeNode }

object TypeParametersApplicationListNodeSerializer extends AstNodeSerializer[TypeParametersApplicationListNode] {

  override protected def doSerialize(node: TypeParametersApplicationListNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val typeParameters = AstToSerializableMapper.serializeSeq(node.typeParameters)
    val children: Seq[SerializableAstNode] = Seq(_annotations, typeParameters)
    NodeSerializableAstNode(SerializableAstNodeKind.TYPE_PARAMETERS_APPLICATION_LIST_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): TypeParametersApplicationListNode = {
    val typeParameters = AstToSerializableMapper.deserializeSeq(children.head, context).asInstanceOf[Seq[WeaveTypeNode]]
    TypeParametersApplicationListNode(typeParameters)
  }
}
