package org.mule.weave.v2.runtime.core.functions.math

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.NumberType
import org.mule.weave.v2.model.values.BooleanValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.model.values.math

object DecimalNumberFunctionValue extends UnaryFunctionValue {
  override val R = NumberType

  override def doExecute(v: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val numberValue: math.Number = v.evaluate
    BooleanValue(!numberValue.isWhole)
  }
}
