package org.mule.weave.v2.compilation.mapper

import org.mule.weave.v2.compilation
import org.mule.weave.v2.compilation.{ SerializableAstNodeLocation, UnknownLocation }
import org.mule.weave.v2.parser.location.{ Location, WeaveLocation }

object SerializableLocationMapper {
  def serialize(location: Location): SerializableAstNodeLocation = {
    location match {
      case org.mule.weave.v2.parser.location.UnknownLocation => compilation.UnknownLocation //Unknown
      case location: WeaveLocation                           => SerializableAstNodeLocation(location.startPosition.index, location.endPosition.index)
    }
  }

  def deserialize(location: SerializableAstNodeLocation, context: SerializerContext): WeaveLocation = {
    location match {
      case UnknownLocation => org.mule.weave.v2.parser.location.UnknownLocation
      case SerializableAstNodeLocation(start, end) =>
        val startPosition = context.position(start)
        val endPosition = context.position(end)
        WeaveLocation(startPosition, endPosition, context.identifier())
    }
  }
}
