package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.updates.ArrayIndexUpdateSelectorNode

object ArrayIndexUpdateSelectorNodeSerializer extends AstNodeSerializer[ArrayIndexUpdateSelectorNode] {

  override protected def doSerialize(node: ArrayIndexUpdateSelectorNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val selector = AstToSerializableMapper.serialize(node.selector)
    val child = AstToSerializableMapper.serializeMaybe(node.child)
    val children: Seq[SerializableAstNode] = Seq(_annotations, selector, child)
    NodeSerializableAstNode(SerializableAstNodeKind.ARRAY_INDEX_UPDATE_SELECTOR_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): ArrayIndexUpdateSelectorNode = {
    val selector = AstToSerializableMapper.deserialize(children.head, context)
    val child = AstToSerializableMapper.deserializeMaybe(children(1), context)
    ArrayIndexUpdateSelectorNode(selector, child)
  }
}
