package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.types.{ NameValueTypeNode, WeaveTypeNode }

object NameValueTypeNodeSerializer extends AstNodeSerializer[NameValueTypeNode] {

  override protected def doSerialize(node: NameValueTypeNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val name = NameTypeNodeSerializer.serialize(node.name)
    val value = AstToSerializableMapper.serialize(node.value)
    val optional = serializeBoolean(node.optional)
    val children: Seq[SerializableAstNode] = Seq(_annotations, name, value, optional)
    NodeSerializableAstNode(SerializableAstNodeKind.NAME_VALUE_TYPE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): NameValueTypeNode = {
    val name = NameTypeNodeSerializer.deserialize(children.head, context)
    val value = AstToSerializableMapper.deserialize(children(1), context).asInstanceOf[WeaveTypeNode]
    val optional = deserializeBoolean(children(2))
    NameValueTypeNode(name, value, optional)
  }
}
