package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.types.{ TypeReferenceNode, WeaveTypeNode }

object TypeReferenceNodeSerializer extends AstNodeSerializer[TypeReferenceNode] {

  override protected def doSerialize(node: TypeReferenceNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val variable = NameIdentifierSerializer.serialize(node.variable)
    val typeArguments = AstToSerializableMapper.serializeMaybeSeq(node.typeArguments)
    val maybeSchema = SchemaNodeSerializer.serializeMaybe(node.maybeSchema)
    val maybeTypeSchema = SchemaNodeSerializer.serializeMaybe(node.maybeTypeSchema)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, variable, typeArguments, maybeSchema, maybeTypeSchema, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.TYPE_REFERENCE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): TypeReferenceNode = {
    val variable = NameIdentifierSerializer.deserialize(children.head, context)
    val typeArguments = AstToSerializableMapper.deserializeMaybeSeq(children(1), context).asInstanceOf[Option[Seq[WeaveTypeNode]]]
    val maybeSchema = SchemaNodeSerializer.deserializeMaybe(children(2), context)
    val maybeTypeSchema = SchemaNodeSerializer.deserializeMaybe(children(3), context)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(4), context)
    TypeReferenceNode(variable, typeArguments, maybeSchema, maybeTypeSchema, annotations)
  }
}
