package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.SerializerContext
import org.mule.weave.v2.parser.ast.header.directives.VersionMajor

object VersionMajorSerializer extends AstNodeSerializer[VersionMajor] {

  override protected def doSerialize(node: VersionMajor, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val children: Seq[SerializableAstNode] = Seq(_annotations, serializeString(node.v))
    NodeSerializableAstNode(SerializableAstNodeKind.VERSION_MAJOR_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): VersionMajor = {
    val v = deserializeString(children.head)
    VersionMajor(v)
  }
}
