package org.mule.weave.v2.interpreted.marker

import org.mule.weave.v2.interpreted.InterpreterPreCompilerMarker
import org.mule.weave.v2.parser.annotation.AstNodeAnnotation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.AstNodeHelper
import org.mule.weave.v2.parser.ast.functions.FunctionNode
import org.mule.weave.v2.parser.phase.ParsingContext
import org.mule.weave.v2.scope.ScopesNavigator

class NativeFunctionMarker extends InterpreterPreCompilerMarker {

  override def mark(node: AstNode, scope: ScopesNavigator, context: ParsingContext): Unit = {
    node match {
      case fn: FunctionNode =>
        if (!fn.body.isAnnotatedWith(classOf[NativeFunctionAnnotation])) {
          if (AstNodeHelper.isNativeCall(fn.body, scope)) {
            fn.body.annotate(NativeFunctionAnnotation())
          }
        }
      case _ =>
      // Nothing to do
    }
  }
}

case class NativeFunctionAnnotation() extends AstNodeAnnotation {

  override def name(): String = {
    "NativeFunction"
  }
}
