package org.mule.weave.v2.interpreted.node.structure

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.node.ValueNode
import org.mule.weave.v2.model.values.Value

/**
  * A node that represents a literal value. It does not needs the context to get the value
  *
  * @tparam T The type of the value
  */
trait LiteralValueNode[+T] extends ValueNode[T] {

  override def doExecute(implicit ctx: ExecutionContext): Value[T] = value

  val value: Value[T]

}

case class ConstantValueNode[T](override val value: Value[T]) extends LiteralValueNode[T]