package org.mule.weave.v2.runtime.core.functions.math

import org.mule.weave.v2.core.exception.InvalidParameterException
import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.ObjectSeq
import org.mule.weave.v2.model.types.NumberType
import org.mule.weave.v2.model.types.ObjectType
import org.mule.weave.v2.model.values.NumberValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.model.values.ValueProvider
import org.mule.weave.v2.model.values.math

import java.math.MathContext

trait BaseBigDecimalUnaryFunctionValue extends BinaryFunctionValue with BaseBigDecimalFunctionValue {

  def applyOperation(lhs: math.Number, context: MathContext)(implicit ctx: EvaluationContext): math.Number

  override val L: NumberType = NumberType
  override val R: ObjectType = configType

  override val rightDefaultValue: Option[ValueProvider] = contextDefaultValue(this)

  override def doExecute(firstValue: L.V, secondValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val dividend = firstValue.evaluate
    val context: ObjectSeq = secondValue.evaluate

    try {
      NumberValue(applyOperation(dividend, toMathContext(context)), delegate = this)
    } catch {
      case _: java.lang.IllegalArgumentException => throw InvalidParameterException(
        "precision",
        "precision must be a positive integer",
        secondValue.location())
    }
  }
}
