package org.mule.weave.v2.runtime.core.functions.stringops

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.capabilities.UnknownLocationCapable
import org.mule.weave.v2.model.types.StringType
import org.mule.weave.v2.model.values.BooleanValue
import org.mule.weave.v2.model.values.Value

object StringStartsWithFunctionValue extends BinaryFunctionValue {
  override val L = StringType
  override val R = StringType

  override def doExecute(leftValue: StringStartsWithFunctionValue.L.V, rightValue: StringStartsWithFunctionValue.R.V)(implicit ctx: EvaluationContext): Value[_] = {
    BooleanValue(leftValue.evaluate.toString.startsWith(rightValue.evaluate.toString), UnknownLocationCapable)
  }
}

object StartsWithFunctionValue {
  val value = Seq(StringStartsWithFunctionValue)
}
