package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.patterns.DefaultPatternNode

object DefaultPatternNodeSerializer extends AstNodeSerializer[DefaultPatternNode] {

  override protected def doSerialize(node: DefaultPatternNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val onMatch = AstToSerializableMapper.serialize(node.onMatch)
    val name = NameIdentifierSerializer.serialize(node.name)
    val children: Seq[SerializableAstNode] = Seq(_annotations, onMatch, name)
    NodeSerializableAstNode(SerializableAstNodeKind.DEFAULT_PATTERN_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): DefaultPatternNode = {
    val onMatch = AstToSerializableMapper.deserialize(children.head, context)
    val name = NameIdentifierSerializer.deserialize(children(1), context)
    DefaultPatternNode(onMatch, name)
  }
}
