package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.types.{ FunctionParameterTypeNode, WeaveTypeNode }

object FunctionParameterTypeNodeSerializer extends AstNodeSerializer[FunctionParameterTypeNode] {

  override protected def doSerialize(node: FunctionParameterTypeNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val name = NameIdentifierSerializer.serializeMaybe(node.name)
    val valueType = AstToSerializableMapper.serialize(node.valueType)
    val optional = serializeBoolean(node.optional)
    val children = Seq(_annotations, name, valueType, optional)
    NodeSerializableAstNode(SerializableAstNodeKind.FUNCTION_PARAMETER_TYPE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): FunctionParameterTypeNode = {
    val name = NameIdentifierSerializer.deserializeMaybe(children.head, context)
    val valueType = AstToSerializableMapper.deserialize(children(1), context).asInstanceOf[WeaveTypeNode]
    val optional = deserializeBoolean(children(2))
    FunctionParameterTypeNode(name, valueType, optional)
  }
}
