package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.functions.FunctionCallParametersNode

object FunctionCallParametersNodeSerializer extends AstNodeSerializer[FunctionCallParametersNode] {

  override protected def doSerialize(node: FunctionCallParametersNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val args = AstToSerializableMapper.serializeSeq(node.args)
    val children: Seq[SerializableAstNode] = Seq(_annotations, args)
    NodeSerializableAstNode(SerializableAstNodeKind.FUNCTION_CALL_PARAMETERS_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): FunctionCallParametersNode = {
    val args = AstToSerializableMapper.deserializeSeq(children.head, context)
    FunctionCallParametersNode(args)
  }
}
