package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.patterns.TypePatternNode

object TypePatternNodeSerializer extends AstNodeSerializer[TypePatternNode] {

  override protected def doSerialize(node: TypePatternNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val pattern = AstToSerializableMapper.serialize(node.pattern)
    val name = NameIdentifierSerializer.serialize(node.name)
    val onMatch = AstToSerializableMapper.serialize(node.onMatch)
    val children: Seq[SerializableAstNode] = Seq(_annotations, pattern, name, onMatch)
    NodeSerializableAstNode(SerializableAstNodeKind.TYPE_PATTERN_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): TypePatternNode = {
    val pattern = AstToSerializableMapper.deserialize(children.head, context)
    val name = NameIdentifierSerializer.deserialize(children(1), context)
    val onMatch = AstToSerializableMapper.deserialize(children(2), context)
    TypePatternNode(pattern, name, onMatch)
  }
}
