package org.mule.weave.v2.interpreted

import org.mule.weave.v2.compilation.mapper.ResourceBasedSerializerContext
import org.mule.weave.v2.compilation.mapper.ast.DocumentNodeSerializer
import org.mule.weave.v2.compilation.message.WeaveBinaryDeserializationError
import org.mule.weave.v2.compilation.serializer.SerializableAstNodeSerializer
import org.mule.weave.v2.parser.MessageCollector
import org.mule.weave.v2.parser.ast.structure.DocumentNode
import org.mule.weave.v2.parser.location.UnknownLocation
import org.mule.weave.v2.parser.phase._
import org.mule.weave.v2.scope.AstNavigator
import org.mule.weave.v2.sdk.BinaryWeaveResource

import java.io.{ ByteArrayInputStream, DataInputStream }

class BinaryCompilationMappingLoaderPhase extends CompilationPhase[BinaryWeaveResource, AstNodeResultAware[DocumentNode] with AstNavigatorResultAware] {

  override def doCall(resource: BinaryWeaveResource, context: ParsingContext): PhaseResult[_ <: AstNodeResultAware[DocumentNode] with AstNavigatorResultAware] = {
    try {
      val serializableAstNode = SerializableAstNodeSerializer.deserialize(new DataInputStream(new ByteArrayInputStream(resource.binaryContent)))
      val documentNode = DocumentNodeSerializer.deserialize(serializableAstNode, ResourceBasedSerializerContext(resource.sourceWeaveResource, context.nameIdentifier))
      new PhaseResult(Option.apply(new BinaryCompilationMappingResult(documentNode)), context.messageCollector)
    } catch {
      case e: Throwable => new PhaseResult(None, MessageCollector().error(WeaveBinaryDeserializationError(context.nameIdentifier, e.getMessage), UnknownLocation))
    }
  }
}

class BinaryCompilationMappingResult(private val documentNode: DocumentNode) extends AstNodeResultAware[DocumentNode] with AstNavigatorResultAware {
  override def astNode: DocumentNode = documentNode

  override def astNavigator: AstNavigator = AstNavigator.apply(documentNode)
}

