package org.mule.weave.v2.runtime.core.functions.mime

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.ObjectType
import org.mule.weave.v2.model.values.StringValue
import org.mule.weave.v2.model.values.Value

object ToMimeTypeStringFunctionValue extends UnaryFunctionValue {
  override val R = ObjectType

  override protected def doExecute(v: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val mimeTypeObjectSeq = v.evaluate.materialize()
    val mimeType = MimeTypeConverter.toMimeType(mimeTypeObjectSeq)
    StringValue(mimeType.toString)
  }

}
